/*
 * Decompiled with CFR 0.152.
 */
package pregenerator;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import pregenerator.base.api.Align;

public class PregenConfig {
    public static boolean LOG_INFO = false;
    public static final PregenConfig INSTANCE = new PregenConfig();
    ForgeConfigSpec generalConfig;
    public final ForgeConfigSpec.IntValue threadingRule;
    public final ForgeConfigSpec.IntValue playerLimit;
    public final ForgeConfigSpec.IntValue deletionTimeLimit;
    public final ForgeConfigSpec.BooleanValue multithreaded;
    public final ForgeConfigSpec.BooleanValue autoRestart;
    public final ForgeConfigSpec.BooleanValue blockOptimization;
    public final ForgeConfigSpec.BooleanValue disableWatchDogOverride;
    public final ForgeConfigSpec.BooleanValue advancedArguments;
    public final ForgeConfigSpec.BooleanValue showDockerWarning;
    public final ForgeConfigSpec.BooleanValue enableMemoryProtector;
    public final ForgeConfigSpec.IntValue requiredFreeMemory;
    public final ForgeConfigSpec.BooleanValue pregenOverlay;
    public final ForgeConfigSpec.EnumValue<Align> pregenHAlign;
    public final ForgeConfigSpec.EnumValue<Align> pregenVAlign;
    public final ForgeConfigSpec.DoubleValue pregenZoom;
    public final ForgeConfigSpec.BooleanValue info;

    private PregenConfig() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("general");
        builder.comment("Defines how many Dimensions can be generated at the same time, this is due to thread limitations mcs worldgen has. 0 => Single Dimension, 1 => Up to 3 dimensions (Ensures each dimension has at least 2 threads), 2 => Up to 5 Dimensions (Dimensions will fight over CPU Threads due to limitations)");
        this.threadingRule = builder.defineInRange("Threading Rule", 2, 0, 2);
        builder.comment(new String[]{"Defines if each world should use multiple threads to generate. This feature can improve worldgen speed drastically, but deadlocks can happen with it too.", "If deadlock issues happen, like the worldgen stops randomly, disabling this might fix it for you at the slight slowdown in worldgen", "If the config is changed the pregeneration needs to be restarted"});
        this.multithreaded = builder.define("Multithreaded WorldGen", true);
        builder.comment("Defines if the Improved Command Arguments should be used on Command Creation. If enabled mod is required on client");
        this.advancedArguments = builder.define("Advanced Command Arguments", FMLEnvironment.dist.isClient());
        builder.comment("Defines if the SyncChunkWrite config should be not forcefully set to false. Note: SyncChunkWrite \"May\" Prevent data corruption. Though this was only enabled since 1.16 before it was always disabled. Downside of this is that HDDs/SSDs during pregen are at 100% usage ALL the time instead of less then 5%. This can lead to hardware failure much much much much more quickly. This is why the override is enabled by default");
        this.blockOptimization = builder.define("Disable ChunkSyncOverride", false);
        builder.comment("Override increases the Watchdog Kill switch to a minimum of 10 minutes instead of 60 seconds. Because Heavy modpacks cause spikes that can last 60 seconds during pregen and saving, this just reduces crashes by minecraft itself and leaves the killswitch");
        this.disableWatchDogOverride = builder.define("Disable Watchdog Override", false);
        builder.comment("Defines how many Players have to be online for the Processor to Auto Pause, -1 = Disabled. It is Inclusive 2 = Allows 1 Player");
        this.playerLimit = builder.defineInRange("Player Limit", -1, -1, Integer.MAX_VALUE);
        builder.comment("Defines how many milliseconds the Chunk Deleter gets per tick");
        this.deletionTimeLimit = builder.defineInRange("Deletion Time", 10, 1, 1000);
        builder.comment("Defines if there should be a check/warn for a missconfigured server where lag will be most likely happen due to little cores being provided.");
        this.showDockerWarning = builder.define("docker-warning", true);
        builder.comment("Defines if the pregenerator should automatically restart on server start. Automatically set to true when a task is running, and automatically set to false if no task is running");
        this.autoRestart = builder.define("auto-restart", false);
        builder.comment("Defines if the pregenerator should kill the server when you get close to running out of memory for a while. This is to prevent World Corruption. Can be enabled/disabled without restart");
        this.enableMemoryProtector = builder.define("enable Memory Protector", FMLEnvironment.dist.isDedicatedServer());
        builder.comment("Defines how much memory should be free before the Memory Protector should kick in.");
        this.requiredFreeMemory = builder.defineInRange("Required Free Memory", 1024, 32, Integer.MAX_VALUE);
        this.info = builder.define("info", true);
        builder.pop();
        builder.push("client");
        builder.push("pregen-overlay");
        builder.comment("Defines if the Pregen Overlay should be enabled");
        this.pregenOverlay = builder.define("pregen-overlay", true);
        builder.comment("Defines the Horizontal Alignment of the UI, left to right");
        this.pregenHAlign = builder.defineEnum("horizontal-alignment", (Enum)Align.START);
        builder.comment("Defines the Vertical Alignment of the UI, top to bottom");
        this.pregenVAlign = builder.defineEnum("vertical-alignment", (Enum)Align.START);
        builder.comment("Defines the Scale of the Overlay");
        this.pregenZoom = builder.defineInRange("scale", 1.0, 0.1, 10.0);
        builder.pop();
        builder.pop();
        this.generalConfig = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.generalConfig, "PregenConfig.toml");
    }

    public void init() {
    }
}

